Attribute VB_Name = "modProfiles"
'-----------------------------------------------------
' MirageBot Profile Manager Module
' Written by Christopher Nevin (lancergli@gmail.com)
'-----------------------------------------------------

Option Explicit

Public SelectedTab As Integer

Public Property Get SelectedBot() As Integer
    'Get the selected bot
    SelectedBot = TabToBotIndex(SelectedTab)
End Property

Public Sub GoPreviousProfile()
On Error Resume Next
    If SelectedTab < 1 Then SelectedTab = 1: ViewProfile SelectedTab: Exit Sub
    SelectedTab = SelectedTab - 1
    ViewProfile SelectedTab
    frmBot.tbsProfile.Tabs(SelectedTab).Selected = True
End Sub

Public Sub GoNextProfile()
On Error Resume Next
    If SelectedTab >= frmBot.tbsProfile.Tabs.Count Then SelectedTab = frmBot.tbsProfile.Tabs.Count: ViewProfile SelectedTab: Exit Sub
    SelectedTab = SelectedTab + 1
    ViewProfile SelectedTab
    frmBot.tbsProfile.Tabs(SelectedTab).Selected = True
End Sub

Public Sub DeleteProfile(Profile As String)
On Error GoTo hErr
    Dim FSO As New FileSystemObject
    If FSO.FileExists(AppData & "Profiles\" & Profile & "\Config.ini") Then FSO.DeleteFile AppData & "Profiles\" & Profile & "\Config.ini", True
    If FSO.FileExists(AppData & "Profiles\" & Profile & "\Database.dat") Then FSO.DeleteFile AppData & "Profiles\" & Profile & "\Database.dat", True
    If FSO.FileExists(AppData & "Profiles\" & Profile & "\Channels.dat") Then FSO.DeleteFile AppData & "Profiles\" & Profile & "\Channels.dat", True
    FSO.DeleteFolder AppData & "Profiles\" & Profile, True
    Set FSO = Nothing
    Dim I As Integer
    For I = 1 To frmBot.tbsProfile.Tabs.Count
        If frmBot.tbsProfile.Tabs(I).Caption = Profile Then
            UnloadProfile TabToBotIndex(I)
            Exit For
        End If
    Next I
    frmConfiguration.BuildProfileList
    Exit Sub
hErr:
    MsgBox "An error occurred when trying to delete this profile: " & vbNewLine & Err.Description, vbCritical, "Delete Profile"
End Sub

Public Sub SaveLoadedProfiles()
    'Initialize profiles array
    Dim I As Integer, Profiles() As String
    ReDim Profiles(0)
    For I = 0 To frmBot.Bot.UBound
        'Check if current bot is loaded
        If (frmBot.Bot(I).IsLoaded) Then
            If LenB(Profiles(0)) = 0 Then
                'Set array item 0 to profile
                Profiles(0) = frmBot.Bot(I).Profile
            Else
                'Add profile to array
                ReDim Preserve Profiles(UBound(Profiles) + 1)
                Profiles(UBound(Profiles)) = frmBot.Bot(I).Profile
            End If
        End If
    Next I
    'Finally, write loaded profiles
    WriteINI AppSettings, "Cache", "LoadedProfiles", Join(Profiles, ":")
End Sub

Public Sub LoadProfile(strProfile As String)
On Error GoTo hErr
1   If IsProfileLoaded(strProfile) Then
2       MsgBox "Profile " & ChrW$(34) & strProfile & ChrW$(34) & " is already loaded!", vbExclamation
        Exit Sub
    End If
    
    Dim BotIndex As Integer, B As BNCS, I As Integer
    BotIndex = -1
    For Each B In frmBot.Bot
3       If Not B.IsLoaded Then BotIndex = I: Exit For
        I = I + 1
    Next B
    
    If BotIndex = -1 Then
        MsgBox "Sorry, you can only load 30 profiles in a single instance.", vbExclamation
        Exit Sub
    End If
    
4   CreateFolder AppData & "Profiles\" & strProfile
    With frmBot
5       .rtbChat(BotIndex).Text = vbNullString
6       .rtbWhsp(BotIndex).Text = vbNullString
7       .lvUsers(BotIndex).ListItems.Clear
        .lvClan(BotIndex).ListItems.Clear
        .lvWhsp(BotIndex).ListItems.Clear
        .lvChannels(BotIndex).ListItems.Clear
        .lvFriends(BotIndex).ListItems.Clear
        
8       .tbsProfile.Tabs.Add(, , strProfile, 1).Tag = BotIndex
        
        If Options.Icons = 1 Then
17          Set .lvUsers(BotIndex).SmallIcons = .imlClassic
18          Set .lvFriends(BotIndex).SmallIcons = .imlClassic
        ElseIf Options.Icons = 2 Then
19          Set .lvUsers(BotIndex).SmallIcons = .imlModern
20          Set .lvFriends(BotIndex).SmallIcons = .imlModern
        Else
21          Set .lvUsers(BotIndex).SmallIcons = .imlAvatar
22          Set .lvFriends(BotIndex).SmallIcons = .imlAvatar
        End If
        
23      'OutputEvent .rtbChat(BotIndex), &HB1, , "MirageBot v" & App.Major & "." & App.Minor & IIf(BETA, " BETA", vbNullString) & " (build: " & App.Revision & ")"
24      'OutputEvent .rtbChat(BotIndex), &HB0, , "Type /commands for a list of commands."
25      'OutputEvent .rtbChat(BotIndex), &HB0, , "Using // will issue a command for all loaded profiles."

        With .Bot(BotIndex)
10          .BotIndex = BotIndex
11          .Profile = strProfile
12          .ProfilePath = AppData & "Profiles\" & strProfile & "\Config.ini"
9           .Loaded
        End With
        
14      If SelectedTab = 0 Then ViewProfile .tbsProfile.Tabs.Count
15      LoadProfileValues BotIndex
16      PluginProfileLoaded BotIndex
        
26      If .Bot(BotIndex).Config.AutoHide Or Options.AutoHideAll Then UnloadTabOnly BotIndex
27      If .Bot(BotIndex).Config.AutoConnect Or Options.AutoConnectAll Then frmBot.tmrStartConnection.Enabled = True
28      If .Bot(BotIndex).Config.AutoLock Or Options.AutoLockAll Then .Bot(BotIndex).IsLocked = True

        .Form_Resize
        .Form_Resize
    End With
    Exit Sub
hErr:
    ErrorHandler Err.Description, Erl, "Profiles", "LoadProfile"
End Sub

Public Sub LoadProfileValues(ByVal intBot As Integer)
On Error GoTo hErr
    With frmBot.Bot(intBot)
1       .Queue.Load .ProfilePath
2       .Config.Load .ProfilePath
3       .Config.LoadProxies AppData & "Profiles\" & .Profile & "\Proxies.dat"
4       .Database.Load AppData & "Profiles\" & .Profile & "\Database.dat"
5       .ReloadPluginsScripts
    End With
    Exit Sub
hErr:
    ErrorHandler Err.Description, Erl, "Profiles", "LoadProfileValues"
End Sub
Public Sub HideControls(intBot As Integer, Optional ByRef Resize As Boolean = True)
    If Not Options.HideEditor Then
        frmBot.picTextBar.Visible = (frmBot.tbsProfile.Tabs.Count > 0) And (intBot > -1)
    Else
        frmBot.picTextBar.Visible = False
    End If
    Dim rtb As RichTextBox, LV As ListView, X As Boolean
    For Each rtb In frmBot.rtbChat
        X = (rtb.Index = intBot) And frmBot.cboList.ListIndex <> 7
        If rtb.Visible <> X Then rtb.Visible = X
    Next
    For Each rtb In frmBot.rtbWhsp
        X = (rtb.Index = intBot) And frmBot.cboList.ListIndex = 7
        If rtb.Visible <> X Then rtb.Visible = X
    Next
    For Each LV In frmBot.lvChannels
        X = (LV.Index = intBot) And Not frmBot.CloseSidebar And frmBot.cboList.ListIndex = 2
        If LV.Visible <> X Then LV.Visible = X
    Next
    For Each LV In frmBot.lvUsers
        X = (LV.Index = intBot) And Not frmBot.CloseSidebar And frmBot.cboList.ListIndex = 0
        If LV.Visible <> X Then LV.Visible = X
    Next
    For Each LV In frmBot.lvClan
        X = (LV.Index = intBot) And Not frmBot.CloseSidebar And frmBot.cboList.ListIndex = 4
        If LV.Visible <> X Then LV.Visible = X
    Next
    For Each LV In frmBot.lvFriends
        X = (LV.Index = intBot) And Not frmBot.CloseSidebar And frmBot.cboList.ListIndex = 5
        If LV.Visible <> X Then LV.Visible = X
    Next
    For Each LV In frmBot.lvWhsp
        X = (LV.Index = intBot) And Not frmBot.CloseSidebar And frmBot.cboList.ListIndex = 7
        If LV.Visible <> X Then LV.Visible = X
    Next
    With frmBot
        X = (intBot > -1) And frmBot.cboList.ListIndex = 1
        If .picFave.Visible <> X Then .picFave.Visible = X
        
        X = (intBot > -1) And frmBot.cboList.ListIndex = 3
        If .lvBanned.Visible <> X Then .lvBanned.Visible = X
        
        X = (intBot > -1) And frmBot.cboList.ListIndex = 6
        If .picRealm.Visible <> X Then .picRealm.Visible = X
    
        X = (intBot > -1)
        If .cboSend.Visible <> X Then .cboSend.Visible = X
        If .cboCommand.Visible <> X Then .cboCommand.Visible = X
        If .shaChat.Visible <> X Then .shaChat.Visible = X
        If .cmdClose.Visible <> X Then .cmdClose.Visible = X
        If .cmdMinimize.Visible <> X Then .cmdMinimize.Visible = X
        If .tbsProfile.Visible <> X Then .tbsProfile.Visible = X
        If .shaCmd.Visible <> X Then .shaCmd.Visible = X
        If .shaSend.Visible <> X Then .shaSend.Visible = X
        
        X = (intBot > -1) And (Options.HideEditor = False)
        If .shaText.Visible <> X Then .shaText.Visible = X
        
        X = (intBot > -1) And Not frmBot.CloseSidebar
        If .cboList.Visible <> X Then .cboList.Visible = X
        If .shaList.Visible <> X Then .shaList.Visible = X
        If .shaListSel.Visible <> X Then .shaListSel.Visible = X
    End With
    If Resize Then frmBot.Form_Resize
End Sub

Public Sub ViewProfile(ByVal intTab As Integer)
On Error GoTo hErr
    Dim intBot As Integer
1   intBot = TabToBotIndex(intTab)
2   If (intBot <> -1) Then
3       DisableURLDetect
4       If Options.Hyperlinks Then
5           EnableURLDetect frmBot.rtbChat(intBot).hwnd, frmBot.hwnd
6           Call URLViewing(True, frmBot.rtbChat(intBot).hwnd)
7       Else
8           Call URLViewing(False, frmBot.rtbChat(intBot).hwnd)
        End If
9       SelectedTab = intTab
10      frmBot.Bot(intBot).IsActive = False
11      HideControls intBot
        
        frmBot.mnuClan.Visible = frmBot.Bot(intBot).Config.IsWarCraft
        frmBot.mnuClanDisband.Enabled = frmBot.Bot(intBot).Clan.InClan And frmBot.Bot(intBot).Clan.Rank = CHIEFTAIN
        frmBot.mnuClanLeave.Enabled = frmBot.Bot(intBot).Clan.InClan
        frmBot.mnuClanCreate.Enabled = frmBot.Bot(intBot).Clan.InClan = False
        
23      frmBot.mnuLockBot.Checked = frmBot.Bot(intBot).IsLocked
        
        'Connection options
26      frmBot.mnuConnect.Caption = IIf(frmBot.Bot(intBot).IsConnected, "Reconnect", "Connect")
    Else
        HideControls -1
27      If (frmBot.tbsProfile.Tabs.Count > 0) Then ViewProfile 1: Exit Sub
    End If
    'Refresh the channel
28  RefreshChannel
    RefreshPlugins
    RefreshScripts
    'Resize the main form
29  frmBot.Form_Resize
    frmBot.cboList_Click
    'Refresh some other stuff
    frmBot.cboSend.SelStart = Len(frmBot.cboSend.Text)
33  frmBot.RefreshCount
    Exit Sub
hErr:
    Close #1
    ErrorHandler Err.Description, Erl, "Profiles", "ViewProfile"
End Sub

Public Sub UnloadProfile(ByVal intBot As Integer)
On Error GoTo hErr
    If (intBot > -1) Then
        With frmBot
            .rtbChat(intBot).Text = vbNullString
            .rtbWhsp(intBot).Text = vbNullString
            .lvUsers(intBot).ListItems.Clear
            .lvFriends(intBot).ListItems.Clear
            .lvClan(intBot).ListItems.Clear
            .lvWhsp(intBot).ListItems.Clear
            .lvChannels(intBot).ListItems.Clear
            .Bot(intBot).Unloaded
        End With
        Dim intTab As Integer
        intTab = BotToTabIndex(intBot)
        If intTab <> -1 Then
            'Check if tab is valid
            If (intTab <= frmBot.tbsProfile.Tabs.Count And intTab > 0) Then
                frmBot.tbsProfile.Tabs.Remove intTab
                If (frmBot.tbsProfile.Tabs.Count > 0) Then ViewProfile 1
            Else
                MsgBox "Cannot unload profile, tab index is out of bounds!", vbExclamation
                Exit Sub
            End If
        End If
    End If
    SelectNextTab
    frmBot.Form_Resize
    Exit Sub
hErr:
    Close #1
    ErrorHandler Err.Description, Erl, "Profiles", "UnloadProfile"
End Sub

Public Sub LoadTabOnly(intBot As Integer)
    'Load the tab, when you switch from IsHidden to tabbed
    frmBot.Bot(intBot).IsHidden = False
    frmBot.tbsProfile.Tabs.Add(, , frmBot.Bot(intBot).Profile, 1).Tag = intBot
    SelectNextTab
End Sub

Public Function UnloadTabOnly(intBot As Integer) As Boolean
    'Unload the tab, but leave the bot loaded (IsHidden)
On Error GoTo hErr
    Dim I As Integer
    For I = 1 To frmBot.tbsProfile.Tabs.Count
        If (Val(frmBot.tbsProfile.Tabs(I).Tag) = intBot) Then
            frmBot.Bot(intBot).IsLoaded = True
            frmBot.Bot(intBot).IsHidden = True
            frmBot.tbsProfile.Tabs.Remove I
            UnloadTabOnly = True
            SelectNextTab
            Exit Function
        End If
    Next I
    SelectNextTab
hErr:
    UnloadTabOnly = False
End Function

Public Function CreateProfile() As String
On Error GoTo hErr
    Dim str As String
    str = InputBox("Enter name for new profile:", "Create Profile")
    str = FixFilename(str)
    If LenB(str) > 0 Then
        Dim P As String
        P = AppData & "Profiles\" & str & "\"
        If CreateFolder(P) = True Then
            CreateFolder P & "Logs\"
            CreateFile P & "Database.dat"
            CreateFile P & "Config.ini"
            frmConfiguration.Show
            frmConfiguration.BuildProfileList
            frmConfiguration.SelectProfile str
            frmBot.RefreshBotList
            CreateProfile = str
        Else
            MsgBox "A profile with that name already exists!", vbExclamation
        End If
    End If
    Exit Function
hErr:
    MsgBox "An error occurred when trying to create a profile: " & vbNewLine & Err.Description, vbCritical, "Create Profile"
End Function

Public Function IsProfileLoaded(ByVal ProfileName As String) As Boolean
On Error GoTo hErr
    Dim B As BNCS
    ProfileName = LCase$(ProfileName)
    For Each B In frmBot.Bot
        If LCase$(B.Profile) = ProfileName Then IsProfileLoaded = True: Exit Function
    Next
    Exit Function
hErr:
    MsgBox "An error occurred while checking if profile was loaded: " & vbNewLine & Err.Description, vbCritical, "Is Profile Loaded"
End Function

Public Function GetProfileIndex(ByVal ProfileName As String) As Integer
On Error GoTo hErr
    Dim B As BNCS
    ProfileName = LCase$(ProfileName)
    For Each B In frmBot.Bot
        If LCase$(B.Profile) = ProfileName Then
            GetProfileIndex = B.BotIndex
            Exit Function
        End If
    Next
    Exit Function
hErr:
    GetProfileIndex = -1
End Function

Public Sub SelectNextTab()
On Error GoTo hErr
    HideControls -1
    frmBot.RefreshCount
    SelectedTab = 0
    RefreshPlugins
    If frmBot.tbsProfile.Tabs.Count > 0 Then
        Dim I As Integer
        For I = 1 To frmBot.tbsProfile.Tabs.Count
            ViewProfile I
            Exit Sub
        Next I
    End If
    Exit Sub
hErr:
    ErrorHandler Err.Description, Erl, "Profiles", "SelectNextTab"
End Sub

Public Function BotToTabIndex(intBot As Integer) As Integer
    'Convert bot to tab index
On Error GoTo hErr
    If frmBot.tbsProfile.Tabs.Count > 0 Then
        Dim I As Integer
        For I = 1 To frmBot.tbsProfile.Tabs.Count
            If (Val(frmBot.tbsProfile.Tabs(I).Tag) = intBot) Then
                BotToTabIndex = I
                Exit Function
            End If
        Next I
    End If
hErr:
    BotToTabIndex = -1
End Function

Public Function TabToBotIndex(intTab As Integer) As Integer
    'Convert tab to bot index
    If (intTab <= frmBot.tbsProfile.Tabs.Count And intTab > 0) Then
        TabToBotIndex = Val(frmBot.tbsProfile.Tabs(intTab).Tag)
    Else
        TabToBotIndex = -1
    End If
End Function
